# PomiGrenade

A comprehensive Pomodoro productivity system with CLI, Telegram bot, and API server - all containerized for easy deployment.

## Overview

PomiGrenade helps you manage tasks and track productivity using the Pomodoro Technique. It consists of three integrated components:

| Component | Description | Technology |
|-----------|-------------|------------|
| **pomo-cli** | Interactive terminal timer with local SQLite storage | Go 1.21+ |
| **pomo-bot** | Telegram bot for mobile task management | Node.js + Telegraf |
| **pomo-api** | REST API server with PostgreSQL backend | Node.js + Express |

## Features

- **Interactive CLI Timer** - Real-time countdown with pause/resume, progress bar, and desktop notifications
- **Telegram Bot Integration** - Manage tasks on the go via Telegram
- **API Sync** - Synchronize tasks between CLI and cloud
- **Docker Deployment** - One-command deployment with Docker Compose
- **Offline-First** - CLI works offline with local SQLite, syncs when online
- **Break Management** - Automatic short (5 min) and long (15 min) breaks
- **Tag Support** - Organize tasks with color-coded tags
- **JSON Output** - Machine-readable output for scripting

## Requirements

### For Docker Deployment (Recommended)
- Docker 20.10+
- Docker Compose v2+

### For Local Development
- Go 1.21+ (for CLI)
- Node.js 18+ (for bot and API)
- SQLite 3 (for CLI local storage)
- PostgreSQL 15 (for API server)

## Quick Start

### Docker Deployment (Recommended)

```bash
# Clone the repository
git clone https://github.com/shantanusoam/PomiGrenade.git
cd PomiGrenade

# Run the deployment script
chmod +x deploy.sh
./deploy.sh

# Edit .env with your Telegram Bot Token
nano .env

# Restart to apply changes
docker compose restart
```

The API will be available at `http://localhost:3000`.

### CLI Installation

```bash
cd pomo-cli-integrated

# Build and install
go build -o pomo-cli .
sudo mv pomo-cli /usr/local/bin/

# Or use the install script
chmod +x build-pomo.sh
sudo ./build-pomo.sh

# Initialize local database
pomo-cli init
```

## Usage

### CLI Commands

```bash
# Initialize database
pomo-cli init

# Add a new task
pomo-cli add "Complete project documentation" -p 4 -d 25m -t "work,docs"

# List all tasks
pomo-cli list

# Start interactive timer for a task
pomo-cli start <task-id>

# View task sessions
pomo-cli sessions <task-id>

# Check current status
pomo-cli status

# Complete a session with notes
pomo-cli complete <session-id> --notes "Finished the intro section"

# Sync with API server
pomo-cli sync-to-api
pomo-cli sync-from-api
```

### CLI Options

| Option | Description | Default |
|--------|-------------|---------|
| `-p, --pomodoros` | Number of pomodoros for task | `1` |
| `-d, --duration` | Duration per pomodoro | `25m` |
| `-t, --tags` | Comma-separated tags | `""` |
| `--api-url` | API server URL | `http://localhost:3000` |
| `--json` | Output in JSON format | `false` |
| `--limit` | Limit number of results | unlimited |

### Interactive Timer Controls

When running `pomo-cli start <task-id>`:

| Key | Action |
|-----|--------|
| `Space` or `P` | Pause/Resume timer |
| `S` | Stop and complete session |
| `Q` | Quit timer |

### Telegram Bot Commands

| Command | Description |
|---------|-------------|
| `/start` | Welcome message and help |
| `/login <email> <password>` | Authenticate with API |
| `/logout` | Clear session |
| `/tasks` | List your active tasks |
| `/add <message>` | Add a new task |
| `/stats` | View productivity statistics |

## Configuration

### Environment Variables

Create a `.env` file in the project root:

```bash
# Required for Telegram Bot
TELEGRAM_BOT_TOKEN=your_bot_token_from_botfather

# Optional: JWT secret for API authentication
JWT_SECRET=your_secret_key_here

# Optional: CLI configuration
POMO_API_URL=http://localhost:3000
POMO_DB_PATH=~/.local/share/pomo/pomo.db
POMO_CONFIG_PATH=~/.config/pomo/config.json
```

### CLI Configuration File

Create `~/.config/pomo/config.json`:

```json
{
  "dateTimeFmt": "2006-01-02 15:04",
  "colors": {
    "work": "blue",
    "personal": "green",
    "urgent": "red"
  }
}
```

Available colors: `black`, `red`, `green`, `yellow`, `blue`, `magenta`, `cyan`, `white` (and `hi*` variants).

## Project Structure

```
PomiGrenade/
├── docker-compose.yml      # Container orchestration
├── deploy.sh               # Deployment script
├── .env                    # Environment variables (create this)
│
├── pomo-cli-integrated/    # Go CLI application
│   ├── main.go             # CLI source code
│   ├── go.mod              # Go dependencies
│   ├── build-pomo.sh       # Build script
│   ├── install.sh          # Installation script
│   └── README.md           # CLI documentation
│
├── pomo-bot/               # Telegram bot
│   ├── index.js            # Bot source code
│   ├── package.json        # Node.js dependencies
│   └── Dockerfile          # Container build
│
└── pomo-api/               # REST API server
    ├── index.js            # API source code
    ├── package.json        # Node.js dependencies
    └── Dockerfile          # Container build
```

## API Endpoints

| Method | Endpoint | Description |
|--------|----------|-------------|
| `POST` | `/api/auth/login` | User authentication |
| `GET` | `/api/tasks` | List all tasks |
| `POST` | `/api/tasks` | Create new task |
| `PUT` | `/api/tasks/:id` | Update task |
| `DELETE` | `/api/tasks/:id` | Delete task |
| `GET` | `/api/stats` | Get productivity statistics |

## Docker Services

| Service | Port | Description |
|---------|------|-------------|
| `postgres` | 5432 (internal) | PostgreSQL database |
| `pomo-api` | 3000 | REST API server |
| `pomo-bot` | - | Telegram bot (no exposed port) |

### Docker Commands

```bash
# Start all services
docker compose up -d

# View logs
docker compose logs -f

# Stop all services
docker compose down

# Rebuild after changes
docker compose up -d --build

# View service status
docker compose ps
```

## Troubleshooting

### CLI Issues

**Database not found**
```bash
pomo-cli init  # Initialize database
```

**Cannot connect to API**
```bash
# Check API URL
echo $POMO_API_URL

# Test API connection
curl http://localhost:3000/api/tasks
```

**Timer not displaying correctly**
- Ensure terminal supports ANSI escape codes
- Try a different terminal emulator (alacritty, kitty, etc.)

### Bot Issues

**Bot not responding**
```bash
# Check bot logs
docker compose logs pomo-bot

# Verify token in .env
grep TELEGRAM_BOT_TOKEN .env
```

### API Issues

**Database connection failed**
```bash
# Check postgres is running
docker compose ps postgres

# View postgres logs
docker compose logs postgres
```

**Port 3000 already in use**
```bash
# Find process using port
lsof -i :3000

# Or change port in docker-compose.yml
```

## Development

### Building the CLI

```bash
cd pomo-cli-integrated
go mod tidy
go build -o pomo-cli .
```

### Running the Bot Locally

```bash
cd pomo-bot
npm install
TELEGRAM_BOT_TOKEN=your_token node index.js
```

### Running Tests

```bash
# CLI integration tests
cd pomo-cli-integrated
chmod +x test-integration.sh
./test-integration.sh
```

## Contributing

1. Fork the repository
2. Create a feature branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

## License

This project is licensed under the MIT License. See `LICENSE` file for details.

## Acknowledgments

- Original [pomo CLI](https://github.com/kevinschoon/pomo) by Kevin Schoon
- [Telegraf](https://telegraf.js.org/) for Telegram bot framework
- [SQLite](https://sqlite.org/) for local storage

---

**Boost your productivity with PomiGrenade!**
