# Pomo CLI - Integrated Version with Local DB and API Sync

![Go Version](https://img.shields.io/badge/Go-1.21+-blue.svg)
![SQLite](https://img.shields.io/badge/SQLite-Local%20Storage-green.svg)
![License](https://img.shields.io/badge/License-MIT-yellow.svg)

A enhanced version of the [pomo CLI](https://github.com/kevinschoon/pomo) that adds local SQLite database storage and API synchronization capabilities while preserving all original functionality.

## 🚀 Installation

### One-Click Install (Recommended)
```bash
curl -fsSL https://raw.githubusercontent.com/shantanusoam/pomo-cli-integrated/main/install.sh | bash
```

### From Source
```bash
git clone https://github.com/shantanusoam/pomo-cli-integrated.git
cd pomo-cli-integrated
go mod tidy
go build -o pomo-cli .
sudo mv pomo-cli /usr/local/bin/
```

### Quick Setup
```bash
# Clone and build
git clone https://github.com/shantanusoam/pomo-cli-integrated.git
cd pomo-cli-integrated
chmod +x build-pomo.sh
sudo ./build-pomo.sh

# Initialize
pomo-cli init
```

## 🎯 Quick Start

```bash
# Initialize local database
pomo-cli init

# Add a new task
pomo-cli add "Complete project documentation" -p 4 -d 25m -t "work,docs"

# List all tasks
pomo-cli list

# Start pomodoro session with interactive timer
pomo-cli start 1

# View sessions
pomo-cli sessions 1

# Sync with API server
pomo-cli sync-to-api
```

## ⏲️ Interactive Timer UI

When you start a pomodoro session, an **interactive terminal UI** opens with:

### Features
- **Real-time countdown timer** - Updates every second with MM:SS format
- **Visual progress bar** - Shows percentage of session completed
- **Color-coded states** - Green (running), Yellow (break), Red (paused)
- **Task information** - Display task name, tags, and progress
- **Desktop notifications** - Alerts when pomodoros and breaks complete
- **Break management** - Automatic 5-minute breaks and 15-minute long breaks (every 4 pomodoros)

### Keyboard Controls
| Key | Action |
|-----|--------|
| `Space` or `P` | Pause/Resume timer |
| `S` | Stop and complete session |
| `Q` | Quit timer |

### Example UI
```
  🍅 POMODORO TIMER

  Task: Complete project documentation
  Tags: work, docs

  Progress: 1/4 pomodoros

  23:45

  ▶  RUNNING

  [████████████████████████████░░░░░░░░░░░░] 68%

  Controls:
    [Space/P] Pause/Resume
    [S]       Stop and complete
    [Q]       Quit
```

## 📋 Commands

| Command | Description | Example |
|---------|-------------|---------|
| `init` | Initialize local database | `pomo-cli init` |
| `add` | Create new task | `pomo-cli add "Task" -p 2 -d 25m -t "tag1,tag2"` |
| `list` | List all tasks | `pomo-cli list` |
| `start` | Start interactive timer | `pomo-cli start 1` |
| `status` | Show current status | `pomo-cli status` |
| `complete` | Complete session | `pomo-cli complete 1 --notes "Done!"` |
| `sessions` | View task sessions | `pomo-cli sessions 1` |
| `sync-to-api` | Upload to API | `pomo-cli sync-to-api` |
| `sync-from-api` | Download from API | `pomo-cli sync-from-api` |
| `pomo` | Run original commands | `pomo-cli pomo list` |

## 🔧 Options

| Option | Description | Default |
|--------|-------------|---------|
| `-p, --pomodoros` | Number of pomodoros | `1` |
| `-d, --duration` | Duration per pomodoro | `25m` |
| `-t, --tags` | Comma-separated tags | `""` |
| `--api-url` | API server URL | `http://localhost:3000` |

## 🏗️ Architecture

```
┌─────────────────┐    ┌─────────────────┐    ┌─────────────────┐
│   Original      │    │   Integrated    │    │      API        │
│   Pomo CLI      │◄──►│   pomo-cli      │◄──►│   Server        │
│                 │    │                 │    │                 │
│ - Timer UI      │    │ - Local SQLite  │    │ - PostgreSQL    │
│ - Notifications │    │ - API Sync      │    │ - Socket.io     │
│ - CLI Interface │    │ - Task Mgmt     │    │ - REST API      │
└─────────────────┘    └─────────────────┘    └─────────────────┘
```

## 📊 Database Schema

### Tasks Table
- `id`: Primary key
- `message`: Task description
- `pomodoros`: Number of pomodoros planned
- `duration`: Duration per pomodoro
- `tags`: Comma-separated tags
- `status`: Task status
- `created_at`: Creation timestamp
- `updated_at`: Last update timestamp

### Sessions Table
- `id`: Primary key
- `task_id`: Foreign key to tasks
- `start_time`: Session start time
- `end_time`: Session end time
- `duration`: Session duration in seconds
- `completed`: Whether session was completed
- `notes`: Session notes

## 🌐 API Integration

Compatible with [pomo-api](https://github.com/shantanusoam/pomo-api) server:

### Endpoints
- `GET /api/tasks` - List all tasks
- `POST /api/tasks` - Create new task
- `PUT /api/tasks/:id` - Update task
- `DELETE /api/tasks/:id` - Delete task
- `GET /api/tasks/:id/sessions` - List task sessions
- `POST /api/tasks/:id/sessions` - Create session
- `PUT /api/sessions/:id` - Complete session

### Setup
```bash
# Start API server
cd pomo-api
npm install
npm start

# Sync data
pomo-cli --api-url http://localhost:3000 sync-to-api
```

## 🔄 Environment Variables

```bash
export POMO_API_URL="http://localhost:3000"
export POMO_DB_PATH="$HOME/.local/share/pomo/pomo.db"
```

## 🧪 Testing

```bash
# Run integration tests
chmod +x test-integration.sh
./test-integration.sh

# Test individual commands
pomo-cli init
pomo-cli add "Test task" -p 1
pomo-cli list
```

## 🛠️ Development

### Project Structure
```
pomo-cli-integrated/
├── main.go              # Main CLI application
├── go.mod              # Go module dependencies
├── build-pomo.sh       # Build and install script
├── test-integration.sh # Test script
├── install.sh          # Automated installer
├── .github/workflows/  # CI/CD pipelines
├── .gitignore          # Git ignore file
└── README.md           # This file
```

### Building
```bash
# Build locally
go build -o pomo-cli .

# Build and install system-wide
sudo ./build-pomo.sh
```

### Contributing
1. Fork the repository
2. Create a feature branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

## 📝 Requirements

- Go 1.21 or later
- SQLite 3
- Optional: pomo-api server for sync features

## 📄 License

This project maintains the same license as the original pomo CLI (MIT). See [LICENSE](LICENSE) for details.

## 🙏 Acknowledgments

- Original [pomo CLI](https://github.com/kevinschoon/pomo) by Kevin Schoon
- [SQLite](https://sqlite.org/) for local storage
- Go community for excellent tools and libraries

## 📚 Related Projects

- [pomo-api](https://github.com/shantanusoam/pomo-api) - Node.js API server
- [pomo](https://github.com/kevinschoon/pomo) - Original CLI tool

## 📦 Releases

Download pre-built binaries from the [Releases](https://github.com/shantanusoam/pomo-cli-integrated/releases) page:

- Linux (amd64, arm64)
- macOS (amd64, arm64)  
- Windows (amd64)

---

**Boost your productivity with enhanced pomodoro task management! 🍅**