# KnowBuild Corporate Website

A modern, high-converting marketing website for KnowBuild QERP.CRM - a connected ERP+CRM system for B2B SMEs. Built with Next.js, TypeScript, and a motion-first design system.

## Features

- Modern UI/UX with deliberate, responsive layout
- 3D graphics and animated backgrounds (Three.js)
- Dark mode with system preference support
- Smooth scrolling with Lenis
- SEO-focused metadata and structured pages
- App Router multi-page routing
- Performance-focused production build

## Tech Stack

- Framework: Next.js 14 (App Router)
- Language: TypeScript 5.8
- Styling: Tailwind CSS 3.4
- 3D Graphics: Three.js, React Three Fiber, Drei
- Animations: Framer Motion 10.16
- Smooth Scrolling: @studio-freight/lenis
- Charts: Recharts 2.10
- Icons: Lucide React

## Prerequisites

- Node.js (v18 or higher recommended)
- pnpm

## Getting Started

### Installation

1. Clone the repository:
   ```bash
   git clone <repository-url>
   cd knowbuildCorprateWebsite
   ```

2. Install dependencies:
   ```bash
   pnpm install
   ```

3. Set up environment variables (if needed):
   Create a `.env.local` file in the root directory:
   ```env
   GEMINI_API_KEY=your_gemini_api_key_here
   ```

4. Start the development server:
   ```bash
   pnpm dev
   ```

   The app will be available at `http://localhost:3000`.

## Available Scripts

- `pnpm dev` - Start development server
- `pnpm build` - Build for production
- `pnpm start` - Start production server
- `pnpm lint` - Run ESLint
- `pnpm deploy` - Run deploy.sh

## Project Structure

```
knowbuildCorprateWebsite/
├── app/                # Next.js app routes
├── components/         # React components
├── constants/          # Static constants
├── context/            # React context providers
├── hooks/              # Global custom hooks
├── lib/                # Utility libraries
├── public/             # Static assets
├── staticData/         # Static data files
├── types/              # TypeScript type definitions
└── utils/              # Shared utilities
```

## Pages

- Home (`/`) - Main landing page with hero, product showcase, and narrative
- Solutions (`/solutions/b2b-qerp-crm`) - Solutions and product offerings
- Pricing (`/pricing/b2b-qerp-crm`) - Pricing information
- Mindset (`/mindset-grow-your-sme`) - Growth mindset content
- Contact (`/contact`) - Contact form and information
- Book Demo (`/book-demo`) - Scheduling page
- Forum (`/forum`) - Q&A community
- Privacy Policy (`/privacy-policy`) - Privacy policy page
- Terms of Service (`/terms-of-service`) - Terms of service page

## Configuration

### Next.js Configuration

The project uses Next.js 14 with App Router and Tailwind CSS for styling.

### Environment Variables

- `GEMINI_API_KEY` - Required only if Gemini API integration is enabled

## Key Components

- Hero - Main landing section
- ProductShowcase - Product demonstration
- SecondBrain - AI-powered features showcase
- Narrative - Storytelling section
- Modules - Product modules overview
- Benefits - Key benefits section
- Pricing - Pricing plans
- FAQ - Frequently asked questions
- Contact - Contact form
- Footer - Site footer with links

## Browser Support

Modern browsers with ES6+ support:
- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)

## License

Private project - All rights reserved

## Contributing

This is a private corporate website. For contributions, please contact the project maintainers.
