'use client';

import React from 'react';
import { MapPin, Phone, Mail, MessageCircle, CheckCircle2 } from 'lucide-react';
import { Button } from '../../components/ui/Button';

export const ContactPageContent: React.FC = () => {
  return (
    <section className="relative pt-32 pb-20 md:pt-40 md:pb-32 bg-slate-50 dark:bg-[#0B1220]">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-12 md:mb-16">
          <h1 className="text-4xl md:text-6xl lg:text-7xl font-bold text-brand-navy dark:text-white mb-4">
            Talk to Us
          </h1>
          <p className="text-lg md:text-xl text-slate-600 dark:text-slate-300 max-w-3xl mx-auto">
            Get in touch with our team to learn how knowbuild can transform your business operations.
          </p>
        </div>

        {/* Main Content Grid */}
        <div className="grid lg:grid-cols-[380px,1fr] gap-8 lg:gap-16 xl:gap-20">
          {/* Left Column - Contact Information */}
          <div className="space-y-8">
            <div>
              <h2 className="text-xl font-bold text-brand-navy dark:text-white mb-6">Contact Information</h2>
              <div className="space-y-5">
                <div className="flex items-start gap-3">
                  <div className="p-2.5 bg-brand-blue/10 rounded-lg flex-shrink-0">
                    <MapPin className="text-brand-blue" size={20} />
                  </div>
                  <div>
                    <h3 className="font-semibold text-brand-navy dark:text-white mb-1 text-sm">Office Address</h3>
                    <p className="text-sm text-slate-600 dark:text-slate-400 leading-relaxed">
                    B-28, Okhla Estate Marg, Pocket B, <br />
                    Okhla Phase I, Okhla Industrial Estate, New Delhi, Delhi 110020
                    </p>
                  </div>
                </div>

                <div className="flex items-start gap-3">
                  <div className="p-2.5 bg-brand-blue/10 rounded-lg flex-shrink-0">
                    <Mail className="text-brand-blue" size={20} />
                  </div>
                  <div>
                    <h3 className="font-semibold text-brand-navy dark:text-white mb-1 text-sm">Email</h3>
                    <a href="mailto:sales@knowbuild.com" className="text-sm text-brand-blue hover:underline">
                      sales@knowbuild.com
                    </a>
                  </div>
                </div>

           
              </div>
            </div>

            {/* Google Maps Embed */}
            <div className="bg-slate-200 dark:bg-slate-800 rounded-2xl overflow-hidden h-72 shadow-lg">
              <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3505.0087429596626!2d77.27533931508236!3d28.53453608246249!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x390ce3e564e47e8d%3A0x2a2e3e3e3e3e3e3e!2sOkhla%20Phase%203%2C%20New%20Delhi%2C%20Delhi!5e0!3m2!1sen!2sin!4v1734516654000"
                width="100%"
                height="100%"
                style={{ border: 0 }}
                allowFullScreen
                loading="lazy"
                referrerPolicy="no-referrer-when-downgrade"
                title="knowbuild Office Location"
              ></iframe>
            </div>
          </div>

          {/* Right Column - Form Section */}
          <div>
            <div className="mb-8">
              <div className="inline-block px-3 py-1 rounded-full bg-brand-orange/10 text-brand-orange font-bold text-xs uppercase tracking-wider mb-4">
                Get Started
              </div>
              <h2 className="text-3xl md:text-4xl font-bold text-brand-navy dark:text-white mb-4 tracking-tight">
                Have Questions?<br />Let's Talk
              </h2>
              <p className="text-base text-slate-600 dark:text-slate-300 mb-6 font-medium">
                Get in touch with our sales team to discuss pricing, enterprise options, or any specific requirements for your business.
              </p>

              <div className="space-y-3 mb-8">
                {[
                  "Pricing information and subscription plans.",
                  "Enterprise solutions and custom requirements.",
                  "Implementation support and onboarding assistance."
                ].map((item, i) => (
                  <div key={i} className="flex gap-3 items-center">
                    <div className="bg-emerald-100 dark:bg-emerald-900/30 p-1 rounded-full flex-shrink-0">
                      <CheckCircle2 className="text-emerald-600 dark:text-emerald-400 w-4 h-4" />
                    </div>
                    <span className="text-sm text-slate-700 dark:text-slate-200 font-medium">{item}</span>
                  </div>
                ))}
              </div>
            </div>

            {/* Contact Form */}
            <div className="bg-white/70 dark:bg-slate-900/70 backdrop-blur-xl p-6 md:p-8 rounded-2xl shadow-xl shadow-slate-200/50 dark:shadow-black/30 border border-white/50 dark:border-slate-700/50">
              <form className="space-y-4" onSubmit={(e) => { e.preventDefault(); alert("Thanks! We'll be in touch."); }}>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <label className="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider mb-2">Full Name</label>
                    <input
                      type="text"
                      required
                      className="w-full px-4 py-2.5 rounded-xl bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 text-slate-900 dark:text-white focus:ring-2 focus:ring-brand-blue/20 focus:border-brand-blue outline-none transition-all text-sm"
                      placeholder="John Doe"
                    />
                  </div>
                  <div>
                    <label className="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider mb-2">Work Email</label>
                    <input
                      type="email"
                      required
                      className="w-full px-4 py-2.5 rounded-xl bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 text-slate-900 dark:text-white focus:ring-2 focus:ring-brand-blue/20 focus:border-brand-blue outline-none transition-all text-sm"
                      placeholder="john@company.com"
                    />
                  </div>
                </div>

                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <label className="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider mb-2">Phone</label>
                    <input
                      type="tel"
                      defaultValue="+91 "
                      className="w-full px-4 py-2.5 rounded-xl bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 text-slate-900 dark:text-white focus:ring-2 focus:ring-brand-blue/20 focus:border-brand-blue outline-none transition-all text-sm"
                    />
                  </div>
                  <div>
                    <label className="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider mb-2">Company Size / # of employees</label>
                    <select className="w-full px-4 py-2.5 rounded-xl bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 text-slate-900 dark:text-white focus:ring-2 focus:ring-brand-blue/20 focus:border-brand-blue outline-none transition-all text-sm appearance-none">
                      <option value="<20">&lt; 20</option>
                      <option value="20-50">20 - 50</option>
                      <option value="51-200">51 - 200</option>
                      <option value="200+">200+</option>
                    </select>
                  </div>
                </div>

                <div>
                  <label className="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider mb-2">Primary Challenge</label>
                  <textarea
                    rows={3}
                    className="w-full px-4 py-2.5 rounded-xl bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 text-slate-900 dark:text-white focus:ring-2 focus:ring-brand-blue/20 focus:border-brand-blue outline-none transition-all resize-none text-sm"
                    placeholder="e.g. We lose track of quotes across branches..."
                  ></textarea>
                </div>

                <Button fullWidth size="lg" type="submit" className="mt-2">
                  Contact Sales Team
                </Button>

                <p className="text-xs text-center text-slate-400 mt-3 font-medium">
                  We respect your privacy. Your details are safe with us.
                </p>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

















