import type { Metadata } from 'next';
import { QuestionsPageContent } from './QuestionsPageContent';
import { seoConfig } from '../../utils/seo-config';

export const metadata: Metadata = {
  title: seoConfig.questions.title,
  description: seoConfig.questions.description,
  alternates: {
    canonical: `https://knowbuild.com${seoConfig.questions.url}`,
  },
  openGraph: {
    title: seoConfig.questions.title,
    description: seoConfig.questions.description,
    url: `https://knowbuild.com${seoConfig.questions.url}`,
    siteName: 'knowbuild',
    type: 'website',
  },
  twitter: {
    card: 'summary_large_image',
    title: seoConfig.questions.title,
    description: seoConfig.questions.description,
  },
};

export default function QuestionsPage() {
  return <QuestionsPageContent />;
}



