import type { Metadata } from 'next';
import { Hero } from '../components/Hero';
import { ProductShowcase } from '../components/ProductShowcase';
import { RoleStrip } from '../components/RoleStrip';
import { Narrative } from '../components/Narrative';
import { Modules } from '../components/Modules';
import { Benefits } from '../components/Benefits';
import { Pricing } from '../components/Pricing';
import { FAQ } from '../components/FAQ';
import { Contact } from '../components/Contact';
import { SecondBrain } from '../components/SecondBrain';
import { seoConfig } from '../utils/seo-config';

export const metadata: Metadata = {
  title: seoConfig.home.title,
  description: seoConfig.home.description,
  alternates: {
    canonical: `https://knowbuild.com${seoConfig.home.url}`,
  },
  openGraph: {
    title: seoConfig.home.title,
    description: seoConfig.home.description,
    url: `https://knowbuild.com${seoConfig.home.url}`,
    siteName: 'knowbuild',
    type: 'website',
  },
  twitter: {
    card: 'summary_large_image',
    title: seoConfig.home.title,
    description: seoConfig.home.description,
  },
};

export default function HomePage() {
  return (
    <>
      <Hero />
      <ProductShowcase />
      <SecondBrain />
      <RoleStrip />
      <Narrative />
      <Modules />
      <Benefits />
      <Pricing />
      <FAQ />
      <Contact />
    </>
  );
}




















