'use client';

import React, { useState } from 'react';
import { Check, ArrowRight, PhoneIncoming, FileText, ShoppingCart, ScrollText, DollarSign, Truck, Package, HeadphonesIcon, Receipt, Users, ArrowRight as ArrowRightIcon, Play } from 'lucide-react';
import { motion } from 'framer-motion';
import { Button } from '../../components/ui/Button';
import { VideoModal } from '../../components/ui/VideoModal';

const modules = [
  { name: 'Inbound Sales', icon: PhoneIncoming },
  { name: 'Sales', icon: DollarSign },
  { name: 'Finance', icon: FileText },
  { name: 'Dispatch', icon: Truck },

  { name: 'Procurement', icon: ShoppingCart },
  { name: 'Warehousing', icon: Package },

  { name: 'Service Support', icon: HeadphonesIcon, isOptional: true, price: 16962, listPrice: 25700 },
  { name: 'Tendering', icon: ScrollText, isOptional: true, price: 29502, listPrice: 44700 },




];

const salesIdProcesses = ['Lead', 'Enquiry', 'Dispatch', 'Invoice', 'Sales Order', 'Opportunity', 'Sales Quote'];
const productIdProcesses = ['Warehousing', 'Purchase', 'Warranty', 'Forecasting', 'Analytics', 'Targets', 'Sales Order'];

export const PricingPageContent: React.FC = () => {
  const [isVideoOpen, setIsVideoOpen] = useState(false);
  const videoUrl = 'https://knowbuild.com/assets/videos/featuresgears.mp4';

  return (
    <section className="relative pt-20 pb-20 md:pt-28 md:pb-32 bg-slate-50 dark:bg-[#0B1220]">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h1 className="text-3xl md:text-5xl font-bold text-brand-navy dark:text-white mb-6">
            Pricing
          </h1>
          <p className="text-lg md:text-xl text-slate-600 dark:text-slate-300 max-w-3xl mx-auto">
            Transparent pricing built for growing B2B SMEs. One system, complete control.
          </p>
        </div>

        {/* Pricing Cards */}
        <div className="max-w-6xl mx-auto mb-20">
          <div className="grid md:grid-cols-2 gap-8">
            {/* Starter Pack */}
            <div className="bg-white dark:bg-slate-800 rounded-3xl shadow-xl overflow-hidden border border-slate-200 dark:border-slate-700">
              {/* Introductory Price Banner */}
              <div className="bg-orange-100 dark:bg-orange-900/30 px-6 py-3 text-center">
                <span className="text-sm font-semibold text-orange-700 dark:text-orange-300 uppercase tracking-wide">
                  Introductory Price
                </span>
              </div>

              <div className="p-8 md:p-10 min-h-full flex flex-col justify-between">
                {/* Pack Name */}
                <div>
                <div className="mb-6">
                  <h3 className="text-2xl font-bold text-brand-blue dark:text-brand-lightBlue mb-2">
                    Starter Pack
                  </h3>
                </div>

                {/* Pricing */}
                <div className="mb-6">
                  <div className="flex items-baseline gap-3 mb-2">
                    <span className="text-4xl md:text-5xl font-bold text-brand-navy dark:text-white">
                      ₹ 35,400
                    </span>
                    <span className="text-lg text-slate-500 dark:text-slate-400">/ANNUM</span>
                  </div>
                  <div className="flex items-center gap-2">
                    <span className="text-slate-500 dark:text-slate-400 text-sm">LIST</span>
                    <span className="text-lg text-slate-400 dark:text-slate-500 line-through">
                      ₹ 53,100/ANNUM
                    </span>
                  </div>
                </div>

                {/* User Licenses */}
                <div className="mb-8">
                  <div className="inline-flex items-center gap-2 bg-slate-100 dark:bg-slate-700 px-4 py-2 rounded-lg">
                    <Users size={18} className="text-brand-blue dark:text-brand-lightBlue" />
                    <span className="text-sm font-medium text-slate-700 dark:text-slate-300">
                      Includes 3 User Licenses
                    </span>
                  </div>
                </div>

                {/* Target Audience */}
                <div className="mb-8">
                  <div className="bg-slate-100 dark:bg-slate-700/50 px-4 py-3 rounded-lg">
                    <p className="text-sm text-slate-700 dark:text-slate-300 font-medium">
                      For B2B SME's with annual revenues <span className="font-bold text-brand-blue dark:text-brand-lightBlue">less than 5 crores</span>
                    </p>
                  </div>
                </div>

                {/* Included Modules */}
                <div className="mb-8">
                  <h4 className="text-lg font-bold text-brand-navy dark:text-white mb-4">
                    INCLUDED MODULES
                  </h4>
                  <div className="grid grid-cols-2 gap-3">
                    {modules.filter((module) => !module.isOptional).map((module, i) => (
                      <div key={i} className="flex items-center gap-2">
                        <div className="w-8 h-8 rounded-lg bg-brand-blue/10 dark:bg-brand-blue/20 flex items-center justify-center">
                          <module.icon size={16} className="text-brand-blue dark:text-brand-lightBlue" />
                        </div>
                        <span className="text-sm text-slate-700 dark:text-slate-300 font-medium">
                          {module.name}
                        </span>
                      </div>
                    ))}
                  </div>
                </div>
                <div className="mb-8">
                  <h4 className="text-lg font-bold text-brand-navy dark:text-white mb-4">
                    OPTIONAL MODULES
                  </h4>
                  <div className="space-y-3">
                    {modules.filter((module) => module.isOptional).map((module, i) => (
                      <div key={i} className="bg-slate-50 dark:bg-slate-700/50 rounded-lg p-3 border border-slate-200 dark:border-slate-600">
                        <div className="flex items-center gap-2 mb-2">
                          <div className="w-8 h-8 rounded-lg bg-brand-blue/10 dark:bg-brand-blue/20 flex items-center justify-center">
                            <module.icon size={16} className="text-brand-blue dark:text-brand-lightBlue" />
                          </div>
                          <span className="text-sm text-slate-700 dark:text-slate-300 font-medium">
                            {module.name}
                          </span>
                        </div>
                        {module.price && (
                          <div className="ml-10 flex items-baseline gap-2">
                            <span className="text-base font-bold text-brand-navy dark:text-white">
                              ₹ {module.price.toLocaleString('en-IN')}
                            </span>
                            <span className="text-xs text-slate-400 dark:text-slate-500 line-through">
                              ₹ {module.listPrice.toLocaleString('en-IN')}
                            </span>
                            <span className="text-xs text-slate-500 dark:text-slate-400">/ANNUM</span>
                          </div>
                        )}
                      </div>
                    ))}
                  </div>
                </div>
                {/* Features */}
                <div className="space-y-3 mb-8">
                  <div className="flex items-center gap-2">
                    <Check className="text-green-600 dark:text-green-400 flex-shrink-0" size={20} />
                    <span className="text-sm text-slate-700 dark:text-slate-300">
                      Digital Invoicing
                    </span>
                  </div>
                  <div className="flex items-start gap-2">
                    <Check className="text-brand-teal flex-shrink-0 mt-0.5" size={20} />
                    <span className="text-sm text-slate-700 dark:text-slate-300">
                      Free Setup & Onboarding Period: <span className="font-semibold">1 Month</span>
                    </span>
                  </div>
                </div>

                {/* Optional Modules Note */}
                <div className="mb-4">
                  <p className="text-xs text-slate-700 dark:text-slate-300 text-center">
                    One-time system onboarding and configuration support (mandatory, charged separately).
                  </p>
                </div>

                </div>
              
                {/* CTA */}
                <a href="#contact" className="block mb-12">
                  <Button variant="primary" size="lg" className="w-full">
                    Get Started <ArrowRight size={20} className="ml-2" />
                  </Button>
                </a>
              </div>
            </div>

            {/* Premium Pack */}
            <div className="bg-gradient-to-br from-purple-50 via-rose-50 to-amber-50 dark:from-purple-950/30 dark:via-rose-950/30 dark:to-amber-950/30 rounded-3xl shadow-2xl overflow-hidden border-2 border-purple-200 dark:border-purple-700/50 relative">
              {/* Popular Badge */}
              <div className="absolute top-4 right-4 bg-gradient-to-r from-purple-600 to-rose-500 text-white px-3 py-1 rounded-full text-xs font-bold shadow-lg">
                POPULAR
              </div>

              {/* Introductory Price Banner */}
              <div className="bg-orange-100 dark:bg-orange-900/30 px-6 py-3 text-center">
                <span className="text-sm font-semibold text-orange-700 dark:text-orange-300 uppercase tracking-wide">
                  Introductory Price
                </span>
              </div>

              <div className="p-8 md:p-10 ">
                {/* Pack Name */}
                <div className="mb-6">
                  <h3 className="text-2xl font-bold bg-gradient-to-r from-purple-600 to-rose-500 bg-clip-text text-transparent dark:from-purple-400 dark:to-rose-400 mb-2">
                    Growth Pack
                  </h3>
                </div>

                {/* Pricing */}
                <div className="mb-6">
                  <div className="flex items-baseline gap-3 mb-2">
                    <span className="text-4xl md:text-5xl font-bold text-brand-navy dark:text-white">
                      ₹ 59,000
                    </span>
                    <span className="text-lg text-slate-500 dark:text-slate-400">/ANNUM</span>
                  </div>
                  <div className="flex items-center gap-2">
                    <span className="text-slate-500 dark:text-slate-400 text-sm">LIST</span>
                    <span className="text-lg text-slate-400 dark:text-slate-500 line-through">
                      ₹ 88,500/ANNUM
                    </span>
                  </div>
                </div>

                {/* User Licenses */}
                <div className="mb-8">
                  <div className="inline-flex items-center gap-2 bg-gradient-to-r from-purple-100 to-rose-100 dark:from-purple-900/40 dark:to-rose-900/40 px-4 py-2 rounded-lg border border-purple-200/50 dark:border-purple-700/30">
                    <Users size={18} className="text-purple-600 dark:text-purple-400" />
                    <span className="text-sm font-medium text-slate-700 dark:text-slate-300">
                      Includes 5 User Licenses
                    </span>
                  </div>
                </div>

                {/* Target Audience */}
                <div className="mb-8">
                  <div className="bg-gradient-to-r from-purple-50 to-rose-50 dark:from-purple-900/30 dark:to-rose-900/30 px-4 py-3 rounded-lg border border-purple-200/50 dark:border-purple-700/30">
                    <p className="text-sm text-slate-700 dark:text-slate-300 font-medium">
                      For B2B SME's with annual revenues <span className="font-bold bg-gradient-to-r from-purple-600 to-rose-500 bg-clip-text text-transparent dark:from-purple-400 dark:to-rose-400">more than 5 crores</span>
                    </p>
                  </div>
                </div>

                {/* Included Modules */}
                <div className="mb-8">
                  <h4 className="text-lg font-bold text-brand-navy dark:text-white mb-4">
                    INCLUDED MODULES
                  </h4>
                  <div className="grid grid-cols-2 gap-3">
                    {modules.filter((module) => !module.isOptional).map((module, i) => (
                      <div key={i} className="flex items-center gap-2">
                        <div className="w-8 h-8 rounded-lg bg-gradient-to-br from-purple-100 to-rose-100 dark:from-purple-900/40 dark:to-rose-900/40 flex items-center justify-center">
                          <module.icon size={16} className="text-purple-600 dark:text-purple-400" />
                        </div>
                        <span className="text-sm text-slate-700 dark:text-slate-300 font-medium">
                          {module.name}
                        </span>
                      </div>
                    ))}
                  </div>
                </div>
                <div className="mb-8">
                  <h4 className="text-lg font-bold text-brand-navy dark:text-white mb-4">
                    OPTIONAL MODULES
                  </h4>
                  <div className="space-y-3">
                    {modules.filter((module) => module.isOptional).map((module, i) => (
                      <div key={i} className="bg-white/60 dark:bg-slate-800/60 rounded-lg p-3 border border-purple-200/50 dark:border-purple-700/30">
                        <div className="flex items-center gap-2 mb-2">
                          <div className="w-8 h-8 rounded-lg bg-gradient-to-br from-purple-100 to-rose-100 dark:from-purple-900/40 dark:to-rose-900/40 flex items-center justify-center">
                            <module.icon size={16} className="text-purple-600 dark:text-purple-400" />
                          </div>
                          <span className="text-sm text-slate-700 dark:text-slate-300 font-medium">
                            {module.name}
                          </span>
                        </div>
                        {module.price && (
                          <div className="ml-10 flex items-baseline gap-2">
                            <span className="text-base font-bold text-purple-600 dark:text-purple-400">
                              ₹ {module.price.toLocaleString('en-IN')}
                            </span>
                            <span className="text-xs text-slate-400 dark:text-slate-500 line-through">
                              ₹ {module.listPrice.toLocaleString('en-IN')}
                            </span>
                            <span className="text-xs text-slate-500 dark:text-slate-400">/ANNUM</span>
                          </div>
                        )}
                      </div>
                    ))}
                  </div>
                </div>
                {/* Features */}
                <div className="space-y-3 mb-4">
                  <div className="flex items-start gap-2">
                    <Check className="text-green-600 dark:text-green-400 flex-shrink-0 mt-0.5" size={20} />
                    <div className="flex-1">
                      <span className="text-sm font-semibold text-slate-700 dark:text-slate-300 block mb-1">
                        E-Invoicing
                      </span>
                      <span className="text-xs text-slate-600 dark:text-slate-400">
                        Direct connectivity to GST portal for e-invoices, e-way bills and credit notes
                      </span>
                    </div>
                  </div>
                  <div className="flex items-start gap-2">
                    <Check className="text-brand-teal flex-shrink-0 mt-0.5" size={20} />
                    <span className="text-sm text-slate-700 dark:text-slate-300">
                      Free Setup & Onboarding Period: <span className="font-semibold">1 Month</span>
                    </span>
                  </div>
                </div>
                <div className="mb-4">
                  <p className="text-xs text-slate-700 dark:text-slate-300 text-center">
                    One-time system onboarding and configuration support (mandatory, charged separately).
                  </p>
                </div>
                {/* Additional User Cost */}
                <div className="mb-8">
                  <div className="bg-orange-50 dark:bg-orange-900/20 px-4 py-2 rounded-lg border border-orange-200 dark:border-orange-800">
                    <p className="text-xs text-slate-700 dark:text-slate-300">
                      Additional per user cost <span className="font-bold text-brand-orange">₹ 12,744/ANNUM</span>
                    </p>
                  </div>
                </div>

                {/* Optional Modules Note */}
           

                {/* CTA */}
                <a href="#contact" className="block">
                  <Button variant="primary" size="lg" className="w-full">
                    Get Started <ArrowRight size={20} className="ml-2" />
                  </Button>
                </a>
              </div>
            </div>
          </div>
        </div>

        {/* 2^n Process Diagram */}

        <div className="max-w-7xl hidden mx-auto mb-20">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.6 }}
            className="bg-white dark:bg-slate-800 rounded-3xl p-8 md:p-12 shadow-xl border border-slate-200 dark:border-slate-700"
          >
            <div className="text-center mb-12">
              <motion.h2
                initial={{ opacity: 0, scale: 0.9 }}
                whileInView={{ opacity: 1, scale: 1 }}
                viewport={{ once: true }}
                transition={{ duration: 0.5 }}
                className="text-4xl md:text-5xl font-bold text-brand-navy dark:text-white mb-3"
              >
                2<sup>n</sup>
              </motion.h2>
              <motion.p
                initial={{ opacity: 0 }}
                whileInView={{ opacity: 1 }}
                viewport={{ once: true }}
                transition={{ delay: 0.2, duration: 0.5 }}
                className="text-lg text-slate-600 dark:text-slate-400 max-w-2xl mx-auto mb-4"
              >
                Every process connected. Every data point linked. Exponential power through unified IDs.
              </motion.p>
              {/* Mobile Watch Button */}
              <motion.button
                onClick={() => setIsVideoOpen(true)}
                className="md:hidden inline-flex items-center gap-2 bg-brand-teal hover:bg-brand-teal/90 text-white px-5 py-2.5 rounded-lg font-semibold transition-all duration-300 shadow-lg hover:shadow-xl mt-4"
                whileHover={{ scale: 1.05 }}
                whileTap={{ scale: 0.95 }}
              >
                <Play size={18} className="fill-white" />
                Watch Demo
              </motion.button>
            </div>

            <div className="grid md:grid-cols-[1fr_auto_1fr] gap-4 lg:gap-8 mb-12 items-center">
              {/* Unique Sales ID */}
              <motion.div
                initial={{ opacity: 0, x: -30 }}
                whileInView={{ opacity: 1, x: 0 }}
                viewport={{ once: true }}
                transition={{ duration: 0.6, delay: 0.3 }}
                className="relative"
              >
                <div className="text-center mb-6">
                  <h3 className="text-2xl font-bold text-brand-blue dark:text-brand-lightBlue mb-2">
                    Unique Sales ID
                  </h3>
                  <p className="text-sm text-slate-500 dark:text-slate-400 mb-6">
                    One ID tracks the entire sales journey
                  </p>
                </div>
                <div className="relative w-full max-w-md mx-auto aspect-square">
                  <svg className="w-full h-full" viewBox="0 0 320 320">
                    {/* Pulsing Outer Ring */}
                    <motion.circle
                      cx="160"
                      cy="160"
                      r="55"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      className="text-brand-blue/30 dark:text-brand-lightBlue/30"
                      animate={{
                        scale: [1, 1.3, 1],
                        opacity: [0.3, 0.1, 0.3],
                      }}
                      transition={{
                        duration: 2,
                        repeat: Infinity,
                        ease: "easeInOut",
                      }}
                    />
                    {/* Animated Center Circle with Pulse */}
                    <motion.circle
                      initial={{ scale: 0 }}
                      whileInView={{ scale: 1 }}
                      viewport={{ once: true }}
                      transition={{ duration: 0.5, delay: 0.5, type: "spring" }}
                      cx="160"
                      cy="160"
                      r="45"
                      fill="currentColor"
                      className="text-brand-blue dark:text-brand-lightBlue drop-shadow-lg"
                    />
                    <motion.circle
                      cx="160"
                      cy="160"
                      r="45"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      className="text-brand-blue/50 dark:text-brand-lightBlue/50"
                      animate={{
                        scale: [1, 1.1, 1],
                        opacity: [0.5, 0.2, 0.5],
                      }}
                      transition={{
                        duration: 2,
                        repeat: Infinity,
                        ease: "easeInOut",
                      }}
                    />
                    <motion.text
                      initial={{ opacity: 0 }}
                      whileInView={{ opacity: 1 }}
                      viewport={{ once: true }}
                      transition={{ delay: 0.7 }}
                      x="160"
                      y="168"
                      textAnchor="middle"
                      className="text-sm font-bold fill-white"
                    >
                      Sales ID
                    </motion.text>
                    
                    {/* Process Nodes and Lines */}
                    {salesIdProcesses.map((process, i) => {
                      const angle = (i * 360) / salesIdProcesses.length - 90;
                      const radius = 110;
                      const x = 160 + Math.cos((angle * Math.PI) / 180) * radius;
                      const y = 160 + Math.sin((angle * Math.PI) / 180) * radius;
                      const isHighlighted = process === 'Sales Order';
                      
                      const lineLength = Math.sqrt(Math.pow(x - 160, 2) + Math.pow(y - 160, 2));
                      const lineAngle = Math.atan2(y - 160, x - 160) * (180 / Math.PI);
                      
                      return (
                        <g key={i}>
                          {/* Base Line */}
                          <line
                            x1="160"
                            y1="160"
                            x2={x}
                            y2={y}
                            stroke="currentColor"
                            strokeWidth={isHighlighted ? "3" : "2"}
                            className={isHighlighted ? "text-brand-orange/40 dark:text-brand-lightOrange/40" : "text-slate-200 dark:text-slate-700"}
                          />
                          {/* Animated Flow Line (for Sales Order) */}
                          {isHighlighted && (
                            <motion.line
                              x1="160"
                              y1="160"
                              x2={x}
                              y2={y}
                              stroke="currentColor"
                              strokeWidth="4"
                              className="text-brand-orange dark:text-brand-lightOrange"
                              strokeDasharray="8 4"
                              animate={{
                                strokeDashoffset: [0, -12],
                              }}
                              transition={{
                                duration: 1.5,
                                repeat: Infinity,
                                ease: "linear",
                              }}
                            />
                          )}
                          {/* Flowing Particles (for Sales Order) */}
                          {isHighlighted && (
                            <>
                              {[0, 0.3, 0.6].map((offset, idx) => (
                                <motion.circle
                                  key={idx}
                                  r="4"
                                  fill="currentColor"
                                  className="text-brand-orange dark:text-brand-lightOrange"
                                  animate={{
                                    cx: [
                                      160 + Math.cos((lineAngle * Math.PI) / 180) * (lineLength * offset),
                                      160 + Math.cos((lineAngle * Math.PI) / 180) * (lineLength * (offset + 0.3)),
                                    ],
                                    cy: [
                                      160 + Math.sin((lineAngle * Math.PI) / 180) * (lineLength * offset),
                                      160 + Math.sin((lineAngle * Math.PI) / 180) * (lineLength * (offset + 0.3)),
                                    ],
                                    opacity: [0, 1, 1, 0],
                                  }}
                                  transition={{
                                    duration: 1.5,
                                    repeat: Infinity,
                                    ease: "linear",
                                    delay: idx * 0.5,
                                  }}
                                />
                              ))}
                            </>
                          )}
                          {/* Animated Node */}
                          <motion.g
                            initial={{ scale: 0, opacity: 0 }}
                            whileInView={{ scale: 1, opacity: 1 }}
                            viewport={{ once: true }}
                            transition={{ 
                              duration: 0.4, 
                              delay: 1 + i * 0.1,
                              type: "spring",
                              stiffness: 200
                            }}
                            whileHover={{ scale: 1.1 }}
                            className="cursor-pointer"
                          >
                            <motion.rect
                              x={x - 40}
                              y={y - 22}
                              width="80"
                              height="44"
                              rx="10"
                              fill={isHighlighted ? "currentColor" : "white"}
                              stroke="currentColor"
                              strokeWidth={isHighlighted ? "3" : "2"}
                              className={isHighlighted 
                                ? "text-brand-orange dark:text-brand-lightOrange drop-shadow-lg" 
                                : "dark:fill-slate-700 text-brand-blue dark:text-brand-lightBlue"
                              }
                              animate={isHighlighted ? {
                                boxShadow: [
                                  "0 0 0px rgba(254, 108, 0, 0)",
                                  "0 0 20px rgba(254, 108, 0, 0.6)",
                                  "0 0 0px rgba(254, 108, 0, 0)",
                                ],
                              } : {}}
                              transition={isHighlighted ? {
                                duration: 2,
                                repeat: Infinity,
                                ease: "easeInOut",
                              } : {}}
                            />
                            <text
                              x={x}
                              y={y + 6}
                              textAnchor="middle"
                              className={`text-xs font-semibold ${isHighlighted ? 'fill-white' : 'fill-brand-navy dark:fill-white'}`}
                            >
                              {process}
                            </text>
                          </motion.g>
                        </g>
                      );
                    })}
                  </svg>
                </div>
              </motion.div>

              {/* Connection Arrow with Continuous Flow - Clickable */}
              <motion.div
                initial={{ opacity: 0, scale: 0 }}
                whileInView={{ opacity: 1, scale: 1 }}
                viewport={{ once: true }}
                transition={{ duration: 0.5, delay: 1.5, type: "spring" }}
                className="hidden md:flex items-center justify-center relative"
              >
                {/* Flowing Particles */}
                <motion.div
                  className="absolute inset-0 flex items-center justify-center"
                  animate={{
                    x: [-20, 20, -20],
                  }}
                  transition={{
                    duration: 3,
                    repeat: Infinity,
                    ease: "easeInOut",
                  }}
                >
                  {[0, 0.5, 1].map((delay, i) => (
                    <motion.div
                      key={i}
                      className="absolute w-2 h-2 rounded-full bg-brand-teal"
                      animate={{
                        x: [-30, 30],
                        opacity: [0, 1, 1, 0],
                      }}
                      transition={{
                        duration: 2,
                        repeat: Infinity,
                        ease: "easeInOut",
                        delay: delay,
                      }}
                    />
                  ))}
                </motion.div>
                <motion.button
                  onClick={() => setIsVideoOpen(true)}
                  className="bg-brand-teal/20 dark:bg-brand-teal/10 rounded-full p-3 md:p-4 border-2 border-brand-teal/50 relative z-10 cursor-pointer group hover:bg-brand-teal/30 dark:hover:bg-brand-teal/20 hover:border-brand-teal transition-all duration-300"
                  animate={{
                    scale: [1, 1.1, 1],
                  }}
                  transition={{
                    duration: 2,
                    repeat: Infinity,
                    ease: "easeInOut",
                  }}
                  whileHover={{ scale: 1.15 }}
                  whileTap={{ scale: 0.95 }}
                  title="Watch how the systems connect"
                >
                  <ArrowRightIcon 
                    size={28} 
                    className="text-brand-teal group-hover:text-brand-teal/80" 
                  />
                </motion.button>
              </motion.div>

              {/* Unique Product ID */}
              <motion.div
                initial={{ opacity: 0, x: 30 }}
                whileInView={{ opacity: 1, x: 0 }}
                viewport={{ once: true }}
                transition={{ duration: 0.6, delay: 0.3 }}
                className="relative"
              >
                <div className="text-center mb-6">
                  <h3 className="text-2xl font-bold text-brand-orange dark:text-brand-lightOrange mb-2">
                    Unique Product ID
                  </h3>
                  <p className="text-sm text-slate-500 dark:text-slate-400 mb-6">
                    One ID tracks the entire product lifecycle
                  </p>
                </div>
                <div className="relative w-full max-w-md mx-auto aspect-square">
                  <svg className="w-full h-full" viewBox="0 0 320 320">
                    {/* Pulsing Outer Ring */}
                    <motion.circle
                      cx="160"
                      cy="160"
                      r="55"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      className="text-brand-orange/30 dark:text-brand-lightOrange/30"
                      animate={{
                        scale: [1, 1.3, 1],
                        opacity: [0.3, 0.1, 0.3],
                      }}
                      transition={{
                        duration: 2,
                        repeat: Infinity,
                        ease: "easeInOut",
                      }}
                    />
                    {/* Animated Center Circle with Pulse */}
                    <motion.circle
                      initial={{ scale: 0 }}
                      whileInView={{ scale: 1 }}
                      viewport={{ once: true }}
                      transition={{ duration: 0.5, delay: 0.5, type: "spring" }}
                      cx="160"
                      cy="160"
                      r="45"
                      fill="currentColor"
                      className="text-brand-orange dark:text-brand-lightOrange drop-shadow-lg"
                    />
                    <motion.circle
                      cx="160"
                      cy="160"
                      r="45"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      className="text-brand-orange/50 dark:text-brand-lightOrange/50"
                      animate={{
                        scale: [1, 1.1, 1],
                        opacity: [0.5, 0.2, 0.5],
                      }}
                      transition={{
                        duration: 2,
                        repeat: Infinity,
                        ease: "easeInOut",
                      }}
                    />
                    <motion.text
                      initial={{ opacity: 0 }}
                      whileInView={{ opacity: 1 }}
                      viewport={{ once: true }}
                      transition={{ delay: 0.7 }}
                      x="160"
                      y="168"
                      textAnchor="middle"
                      className="text-sm font-bold fill-white"
                    >
                      Product ID
                    </motion.text>
                    
                    {/* Process Nodes and Lines */}
                    {productIdProcesses.map((process, i) => {
                      const angle = (i * 360) / productIdProcesses.length - 90;
                      const radius = 110;
                      const x = 160 + Math.cos((angle * Math.PI) / 180) * radius;
                      const y = 160 + Math.sin((angle * Math.PI) / 180) * radius;
                      const isHighlighted = process === 'Sales Order';
                      
                      const lineLength = Math.sqrt(Math.pow(x - 160, 2) + Math.pow(y - 160, 2));
                      const lineAngle = Math.atan2(y - 160, x - 160) * (180 / Math.PI);
                      
                      return (
                        <g key={i}>
                          {/* Base Line */}
                          <line
                            x1="160"
                            y1="160"
                            x2={x}
                            y2={y}
                            stroke="currentColor"
                            strokeWidth={isHighlighted ? "3" : "2"}
                            className={isHighlighted ? "text-brand-blue/40 dark:text-brand-lightBlue/40" : "text-slate-200 dark:text-slate-700"}
                          />
                          {/* Animated Flow Line (for Sales Order) */}
                          {isHighlighted && (
                            <motion.line
                              x1="160"
                              y1="160"
                              x2={x}
                              y2={y}
                              stroke="currentColor"
                              strokeWidth="4"
                              className="text-brand-blue dark:text-brand-lightBlue"
                              strokeDasharray="8 4"
                              animate={{
                                strokeDashoffset: [0, -12],
                              }}
                              transition={{
                                duration: 1.5,
                                repeat: Infinity,
                                ease: "linear",
                              }}
                            />
                          )}
                          {/* Flowing Particles (for Sales Order) */}
                          {isHighlighted && (
                            <>
                              {[0, 0.3, 0.6].map((offset, idx) => (
                                <motion.circle
                                  key={idx}
                                  r="4"
                                  fill="currentColor"
                                  className="text-brand-blue dark:text-brand-lightBlue"
                                  animate={{
                                    cx: [
                                      160 + Math.cos((lineAngle * Math.PI) / 180) * (lineLength * offset),
                                      160 + Math.cos((lineAngle * Math.PI) / 180) * (lineLength * (offset + 0.3)),
                                    ],
                                    cy: [
                                      160 + Math.sin((lineAngle * Math.PI) / 180) * (lineLength * offset),
                                      160 + Math.sin((lineAngle * Math.PI) / 180) * (lineLength * (offset + 0.3)),
                                    ],
                                    opacity: [0, 1, 1, 0],
                                  }}
                                  transition={{
                                    duration: 1.5,
                                    repeat: Infinity,
                                    ease: "linear",
                                    delay: idx * 0.5,
                                  }}
                                />
                              ))}
                            </>
                          )}
                          {/* Animated Node */}
                          <motion.g
                            initial={{ scale: 0, opacity: 0 }}
                            whileInView={{ scale: 1, opacity: 1 }}
                            viewport={{ once: true }}
                            transition={{ 
                              duration: 0.4, 
                              delay: 1 + i * 0.1,
                              type: "spring",
                              stiffness: 200
                            }}
                            whileHover={{ scale: 1.1 }}
                            className="cursor-pointer"
                          >
                            <motion.rect
                              x={x - 40}
                              y={y - 22}
                              width="80"
                              height="44"
                              rx="10"
                              fill={isHighlighted ? "currentColor" : "white"}
                              stroke="currentColor"
                              strokeWidth={isHighlighted ? "3" : "2"}
                              className={isHighlighted 
                                ? "text-brand-blue dark:text-brand-lightBlue drop-shadow-lg" 
                                : "dark:fill-slate-700 text-brand-orange dark:text-brand-lightOrange"
                              }
                              animate={isHighlighted ? {
                                boxShadow: [
                                  "0 0 0px rgba(0, 82, 204, 0)",
                                  "0 0 20px rgba(0, 82, 204, 0.6)",
                                  "0 0 0px rgba(0, 82, 204, 0)",
                                ],
                              } : {}}
                              transition={isHighlighted ? {
                                duration: 2,
                                repeat: Infinity,
                                ease: "easeInOut",
                              } : {}}
                            />
                            <text
                              x={x}
                              y={y + 6}
                              textAnchor="middle"
                              className={`text-xs font-semibold ${isHighlighted ? 'fill-white' : 'fill-brand-navy dark:fill-white'}`}
                            >
                              {process}
                            </text>
                          </motion.g>
                        </g>
                      );
                    })}
                  </svg>
                </div>
              </motion.div>
            </div>

            {/* Connection Explanation */}
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.6, delay: 1.8 }}
              className="mt-12 bg-gradient-to-r from-brand-blue/10 via-brand-teal/10 to-brand-orange/10 dark:from-brand-blue/20 dark:via-brand-teal/20 dark:to-brand-orange/20 rounded-2xl p-6 md:p-8 border border-brand-teal/30"
            >
              <div className="flex flex-col md:flex-row items-center justify-center gap-4 md:gap-8">
                <div className="flex z-10 items-center gap-3">
                  <div className="w-12 h-12 rounded-full bg-brand-blue dark:bg-brand-lightBlue flex items-center justify-center">
                    <span className="text-white font-bold text-sm">S</span>
                  </div>
                  <span className="text-brand-navy dark:text-white font-semibold">Sales ID</span>
                </div>
                <ArrowRightIcon className="text-brand-teal hidden md:block" size={24} />
                <div className="flex items-center gap-3 bg-brand-teal/20 dark:bg-brand-teal/30 px-4 py-2 rounded-lg border-2 border-brand-teal/50">
                  <span className="text-brand-teal font-bold text-sm">Sales Order</span>
                </div>
                <ArrowRightIcon className="text-brand-teal hidden md:block" size={24} />
                <div className="flex items-center gap-3">
                  <div className="w-12 h-12 rounded-full bg-brand-orange dark:bg-brand-lightOrange flex items-center justify-center">
                    <span className="text-white font-bold text-sm">P</span>
                  </div>
                  <span className="text-brand-navy dark:text-white font-semibold">Product ID</span>
                </div>
              </div>
              <p className="text-center mt-6 text-sm md:text-base text-slate-600 dark:text-slate-300 max-w-3xl mx-auto">
                <span className="font-semibold text-brand-teal">Sales Order</span> is the bridge that connects both systems, 
                creating a unified workflow where sales and product data flow seamlessly together.
              </p>
              
              {/* Watch Demo Button */}
              <div className="mt-8 text-center">
                <motion.button
                  onClick={() => setIsVideoOpen(true)}
                  className="inline-flex items-center gap-2 bg-brand-teal hover:bg-brand-teal/90 text-white px-6 py-3 rounded-xl font-semibold transition-all duration-300 shadow-lg hover:shadow-xl hover:scale-105 active:scale-95"
                  whileHover={{ scale: 1.05 }}
                  whileTap={{ scale: 0.95 }}
                >
                  <Play size={20} className="fill-white" />
                  Watch How It Works
                </motion.button>
              </div>
            </motion.div>
          </motion.div>
        </div>

        {/* Video Modal */}
        <VideoModal
          isOpen={isVideoOpen}
          onClose={() => setIsVideoOpen(false)}
          videoUrl={videoUrl}
          title="How Knowbuild Systems Connect - 2^n Power"
          autoPlay={false}
        />

        {/* Slogan Section */}
        <div className="max-w-4xl mx-auto mb-20 text-center">
          <p className="text-4xl md:text-5xl font-bold text-brand-navy dark:text-white">
            We Grow <span className="text-brand-blue dark:text-brand-lightBlue">WHEN</span> you Grow.
          </p>
        </div>

        {/* Pricing FAQs */}
        <div className="max-w-4xl mx-auto mb-16">
          <h2 className="text-3xl font-bold text-brand-navy dark:text-white mb-8 text-center">Pricing FAQs</h2>
          <div className="space-y-4">
            {[
              {
                q: "Is knowbuild a SaaS product or available as outright purchase?",
                a: "knowbuild is offered as a SaaS (Software as a Service) subscription for most customers, ensuring you always have the latest features and updates. For enterprises with specific requirements, outright purchase options can be discussed. Contact our sales team for details."
              },
              {
                q: "What's included in the base subscription?",
                a: "Our base subscription includes all core modules: Inbound Sales, Sales, Dispatch, Warehousing, Finance, Procurement, Analytics, and Administration. You get a complete operating system without hidden module unlock fees."
              },
              {
                q: "Are there any setup or implementation fees?",
                a: "Implementation and data migration are included in your subscription. Our team assists with setup to ensure a smooth 2-4 week go-live process. We offer 1 month of free setup and onboarding."
              },
              {
                q: "Can we scale pricing as we grow?",
                a: "Yes! Pricing is based on your company size and usage. We believe in growing together—our pricing scales with your business. Additional users can be added at ₹12,744/ANNUM per user for Premium Pack customers."
              }
            ].map((faq, i) => (
              <details key={i} className="group bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 rounded-2xl overflow-hidden">
                <summary className="flex justify-between items-center p-6 cursor-pointer list-none font-medium text-lg text-brand-navy dark:text-white hover:text-brand-blue transition-colors">
                  {faq.q}
                  <span className="transition-transform group-open:rotate-180 text-slate-400 ml-4">↓</span>
                </summary>
                <div className="px-6 pb-6 text-slate-600 dark:text-slate-400 leading-relaxed">
                  {faq.a}
                </div>
              </details>
            ))}
          </div>
        </div>

        {/* CTA Section */}
        <div className="max-w-4xl mx-auto text-center bg-white dark:bg-slate-800 rounded-2xl p-12 shadow-lg">
          <h2 className="text-3xl font-bold text-brand-navy dark:text-white mb-4">Ready to Get Started?</h2>
          <p className="text-slate-600 dark:text-slate-400 mb-8 max-w-2xl mx-auto">
            Schedule a personalized demo to see how knowbuild can transform your business operations.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="/book-demo">
              <Button variant="primary" size="lg">Book Demo</Button>
            </a>
            <a href="/contact">
              <Button variant="outline" size="lg">Contact Sales</Button>
            </a>
          </div>
        </div>
      </div>
    </section>
  );
};









