import type { Metadata } from 'next';
import { Solutions } from '../../../components/Solutions';
import { seoConfig } from '../../../utils/seo-config';

export const metadata: Metadata = {
  title: seoConfig.solutionsOverview.title,
  description: seoConfig.solutionsOverview.description,
  alternates: {
    canonical: `https://knowbuild.com${seoConfig.solutionsOverview.url}`,
  },
  openGraph: {
    title: seoConfig.solutionsOverview.title,
    description: seoConfig.solutionsOverview.description,
    url: `https://knowbuild.com${seoConfig.solutionsOverview.url}`,
    siteName: 'knowbuild',
    type: 'website',
  },
  twitter: {
    card: 'summary_large_image',
    title: seoConfig.solutionsOverview.title,
    description: seoConfig.solutionsOverview.description,
  },
};

export default function SolutionsOverviewPage() {
  return <Solutions />;
}


