'use client';

import React from 'react';
import { Section } from './ui/Section';
import { Button } from './ui/Button';
import { CheckCircle2 } from 'lucide-react';

export const Contact: React.FC = () => {
  return (
    <Section id="contact" className="mb-20" theme="contact">
      <div className="grid lg:grid-cols-2 gap-12 lg:gap-24 items-center">
        
        {/* Left Copy */}
        <div>
          <div className="inline-block px-3 py-1 rounded-full bg-brand-orange/10 text-brand-orange font-bold text-xs uppercase tracking-wider mb-4">
            Get Started
          </div>
          <h2 className="text-4xl md:text-5xl font-bold text-brand-navy dark:text-white mb-6 tracking-tight">
            Have Questions? <br/>Let's Talk
          </h2>
          <p className="text-lg text-slate-600 dark:text-slate-300 mb-10 font-medium">
            Get in touch with our sales team to discuss pricing, enterprise options, or any specific requirements for your business.
          </p>
          
          <div className="space-y-6 mb-8">
            {[
              "Pricing information and subscription plans.",
              "Enterprise solutions and custom requirements.",
              "Implementation support and onboarding assistance."
            ].map((item, i) => (
              <div key={i} className="flex gap-4 items-center p-4 bg-white dark:bg-slate-800 rounded-xl border border-slate-100 dark:border-slate-700 shadow-sm">
                <div className="bg-emerald-100 dark:bg-emerald-900/30 p-1 rounded-full"><CheckCircle2 className="text-emerald-600 dark:text-emerald-400 w-5 h-5" /></div>
                <span className="text-slate-700 dark:text-slate-200 font-semibold">{item}</span>
              </div>
            ))}
          </div>
        </div>

        {/* Right Form */}
        <div className="relative">
          {/* Decor blob */}
          <div className="absolute -top-10 -right-10 w-64 h-64 bg-brand-blue/10 dark:bg-brand-blue/5 rounded-full blur-3xl -z-10"></div>

          <div className="bg-white/70 dark:bg-slate-900/70 backdrop-blur-xl p-8 md:p-10 rounded-3xl shadow-2xl shadow-slate-200/50 dark:shadow-black/30 border border-white/50 dark:border-slate-700/50">
            <form className="space-y-5" onSubmit={(e) => { e.preventDefault(); alert("Thanks! We'll be in touch."); }}>
              <div className="grid grid-cols-2 gap-5">
                <div>
                  <label className="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider mb-2">Full Name</label>
                  <input type="text" required className="w-full px-4 py-3 rounded-xl bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 text-slate-900 dark:text-white focus:ring-2 focus:ring-brand-blue/20 focus:border-brand-blue outline-none transition-all shadow-inner-light" placeholder="John Doe" />
                </div>
                 <div>
                  <label className="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider mb-2">Work Email</label>
                  <input type="email" required className="w-full px-4 py-3 rounded-xl bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 text-slate-900 dark:text-white focus:ring-2 focus:ring-brand-blue/20 focus:border-brand-blue outline-none transition-all shadow-inner-light" placeholder="john@company.com" />
                </div>
              </div>

              <div className="grid grid-cols-2 gap-5">
                <div>
                  <label className="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider mb-2">Phone</label>
                  <input type="tel" defaultValue="+91 " className="w-full px-4 py-3 rounded-xl bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 text-slate-900 dark:text-white focus:ring-2 focus:ring-brand-blue/20 focus:border-brand-blue outline-none transition-all shadow-inner-light" />
                </div>
                <div>
                  <label className="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider mb-2">Company Size / # of employees</label>
                  <select className="w-full px-4 py-3 rounded-xl bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 text-slate-900 dark:text-white focus:ring-2 focus:ring-brand-blue/20 focus:border-brand-blue outline-none transition-all shadow-inner-light appearance-none">
                    <option value="<20">&lt; 20</option>
                    <option value="20-50">20 - 50</option>
                    <option value="51-200">51 - 200</option>
                    <option value="200+">200+</option>
                  </select>
                </div>
              </div>

              <div>
                <label className="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider mb-2">Primary Challenge</label>
                <textarea rows={3} className="w-full px-4 py-3 rounded-xl bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 text-slate-900 dark:text-white focus:ring-2 focus:ring-brand-blue/20 focus:border-brand-blue outline-none transition-all shadow-inner-light resize-none" placeholder="e.g. We lose track of quotes across branches..."></textarea>
              </div>

              <Button fullWidth size="lg" type="submit" className="mt-4 text-lg">Contact Sales Team</Button>
              
              <p className="text-xs text-center text-slate-400 mt-4 font-medium">
                We respect your privacy. Your details are safe with us.
              </p>
            </form>
          </div>
        </div>

      </div>
    </Section>
  );
};
