'use client';

import React from 'react';
import Image from 'next/image';
import { motion } from 'framer-motion';
import { cn } from '@/lib/utils';
// @ts-ignore
import CardSwapComponent, { Card as CardComponent } from './CardSwap';

const CardSwap = CardSwapComponent as any;
const Card = CardComponent as any;

interface DashboardCarouselProps {
  yHero?: any; // MotionValue for scroll-based transform
}

const dashboardConfigs = [
  {
    src: '/FinanceDashboard.png',
    alt: 'Finance Dashboard',
    dotClassName:
      'bg-gradient-to-br from-indigo-500 via-fuchsia-500 to-sky-400 shadow-[0_0_0_3px_rgba(255,255,255,0.60),0_0_18px_rgba(99,102,241,0.35)] dark:shadow-[0_0_0_3px_rgba(2,6,23,0.65),0_0_18px_rgba(99,102,241,0.35)]',
    badgeTintClassName:
      'bg-gradient-to-r from-indigo-500/10 via-fuchsia-500/6 to-sky-400/10 dark:from-indigo-500/16 dark:via-fuchsia-500/10 dark:to-sky-400/12',
    textColor: 'text-brand-blue',
    width: 650,
    height: 360,
  },
  {
    src: '/TargetSummaryDashbaord.png',
    alt: 'Deep Dive Analytics',
    dotClassName:
      'bg-gradient-to-br from-amber-400 via-orange-500 to-rose-500 shadow-[0_0_0_3px_rgba(255,255,255,0.60),0_0_18px_rgba(249,115,22,0.38)] dark:shadow-[0_0_0_3px_rgba(2,6,23,0.65),0_0_18px_rgba(249,115,22,0.38)]',
    badgeTintClassName:
      'bg-gradient-to-r from-amber-400/10 via-orange-500/6 to-rose-500/10 dark:from-amber-400/14 dark:via-orange-500/10 dark:to-rose-500/12',
    textColor: 'text-brand-orange',
    width: 650,
    height: 360,
  },
  {
    src: '/AdminSalesDashbaord.png',
    alt: 'Sales Dashboard',
    dotClassName:
      'bg-gradient-to-br from-emerald-400 via-green-500 to-lime-400 shadow-[0_0_0_3px_rgba(255,255,255,0.60),0_0_18px_rgba(34,197,94,0.35)] dark:shadow-[0_0_0_3px_rgba(2,6,23,0.65),0_0_18px_rgba(34,197,94,0.35)]',
    badgeTintClassName:
      'bg-gradient-to-r from-emerald-400/10 via-green-500/6 to-lime-400/10 dark:from-emerald-400/14 dark:via-green-500/10 dark:to-lime-400/12',
    textColor: 'text-brand-green',
    width: 650,
    height: 360,
  },
];

export const DashboardCarousel: React.FC<DashboardCarouselProps> = ({ yHero }) => {
  return (
    <motion.div
      style={{ y: yHero }}
      className="relative hidden lg:block"
    >
      <div
        className="relative flex items-center justify-center -mt-[40rem]"
        style={{ height: '700px', position: 'relative' }}
      >
        <CardSwap
          cardDistance={60}
          verticalDistance={70}
          delay={4000}
          pauseOnHover={false}
          width={650}
          height={360}
        >
          {dashboardConfigs.map((config, index) => (
            
            <Card
            key={index}
            className="group relative rounded-2xl overflow-hidden bg-white dark:bg-slate-900 border border-slate-200/60 dark:border-slate-700/60 shadow-[0_14px_50px_rgba(0,0,0,0.12)] transition-all duration-300 hover:-translate-y-1 hover:shadow-[0_24px_80px_rgba(0,0,0,0.20)]"
          >
            {/* Subtle vignette for depth */}
            <div className="pointer-events-none absolute inset-0 z-0 bg-gradient-to-b from-black/10 via-transparent to-transparent dark:from-black/40" />

            {/* Title badge */}
            <div className="pointer-events-none absolute top-5 left-1/2 z-10 -translate-x-1/2 px-4 flex justify-center text-center w-[min(560px,calc(100%-2rem))]">
              <div className="relative isolate overflow-hidden inline-flex min-w-[240px] items-center justify-center gap-2.5 rounded-full px-6 py-2.5 backdrop-blur-md bg-gradient-to-r from-white/80 via-white/70 to-white/55 dark:from-slate-950/65 dark:via-slate-950/55 dark:to-slate-950/45 border border-white/70 dark:border-slate-700/60 ring-1 ring-black/5 dark:ring-white/5 shadow-[0_10px_30px_rgba(0,0,0,0.18)] transition-all duration-300 group-hover:shadow-[0_16px_45px_rgba(0,0,0,0.22)]">
                {/* subtle accent tint behind glass */}
                <div
                  className={cn(
                    'pointer-events-none absolute inset-0 -z-10',
                    config.badgeTintClassName
                  )}
                />

                {/* Shine pass (hover) */}
                <div className="pointer-events-none absolute inset-0 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                  <div className="absolute -inset-y-6 -inset-x-16 translate-x-[-55%] group-hover:translate-x-[55%] transition-transform duration-700 ease-out bg-gradient-to-r from-white/0 via-white/45 to-white/0 dark:via-white/12 rotate-12" />
                </div>

                {/* Accent dot */}
                <span
                  className={cn(
                    'h-2.5 w-2.5 rounded-full',
                    config.dotClassName ??
                      'bg-gradient-to-br from-indigo-500 via-fuchsia-500 to-amber-400 shadow-[0_0_0_3px_rgba(255,255,255,0.60)] dark:shadow-[0_0_0_3px_rgba(2,6,23,0.65)]'
                  )}
                />

                {/* Label */}
                <span className="text-[12.5px] leading-none font-semibold tracking-wide text-slate-900/90 dark:text-slate-50 drop-shadow-[0_1px_0_rgba(255,255,255,0.35)] dark:drop-shadow-none">
                  {config.alt}
                </span>
              </div>
            </div>
            <Image
              src={config.src}
              alt={config.alt}
              width={config.width}
              height={config.height}
              className="w-full h-full object-contain bg-white dark:bg-slate-950"
              quality={100}
              priority
            />
          </Card>
          ))}
        </CardSwap>
      </div>
    </motion.div>
  );
};


