'use client';

import React from 'react';
import { Section } from './ui/Section';
import { Check, ArrowRight } from 'lucide-react';
import { Button } from './ui/Button';
import { motion } from 'framer-motion';

export const Pricing: React.FC = () => {
  return (
    <Section id="pricing" theme="pricing">
      <motion.div
        whileHover={{ scale: 1.01 }}
        className="relative bg-gradient-to-br from-[#0052CC] via-[#0B1220] to-[#0052CC] rounded-[2.5rem] overflow-hidden shadow-2xl text-white isolate"
      >
        {/* Holographic Noise Overlay */}
        <div className="absolute inset-0 opacity-20 mix-blend-overlay bg-[url('https://grainy-gradients.vercel.app/noise.svg')]"></div>

        {/* Animated Orbs */}
        <div className="absolute top-0 left-0 w-96 h-96 bg-brand-teal/30 rounded-full -translate-x-1/2 -translate-y-1/2 blur-[100px] animate-pulse"></div>
        <div className="absolute bottom-0 right-0 w-96 h-96 bg-brand-orange/30 rounded-full translate-x-1/2 translate-y-1/2 blur-[100px] animate-pulse delay-1000"></div>

        <div className="relative px-8 py-20 md:px-20 md:py-24 text-center z-10">
          <h2 className="text-4xl md:text-5xl font-bold mb-6 tracking-tight">One Price. <span className="text-brand-teal">Complete Control.</span></h2>
          <p className="text-blue-100/80 text-lg md:text-xl mb-12 max-w-2xl mx-auto leading-relaxed">
            Why pay for 5 different tools? knowbuild replaces your CRM, ERP, Inventory, and Service software with one simple subscription.
          </p>

          <div className="grid sm:grid-cols-3 gap-6 max-w-4xl mx-auto mb-16">
            {["All Modules Included", "No Hidden Fees", "Full Implementation"].map((item, i) => (
              <div key={i} className="bg-white/5 backdrop-blur-md p-5 rounded-2xl border border-white/10 flex items-center gap-3 justify-center group hover:bg-white/10 transition-colors">
                <div className="bg-brand-orange p-1 rounded-full shadow-glow-orange"><Check size={14} /></div>
                <span className="font-medium tracking-wide">{item}</span>
              </div>
            ))}
          </div>

          <a href="#contact">
            <Button variant="secondary" size="lg" className="text-brand-blue hover:bg-blue-50 border-none shadow-xl font-bold text-lg px-10">
              Get Custom Pricing <ArrowRight size={20} className="ml-2" />
            </Button>
          </a>
        </div>
      </motion.div>
    </Section>
  );
};
