'use client';

import React from 'react';
import { motion } from 'framer-motion';

export const SecondBrainBanner: React.FC = () => {
  return (
    <section className="relative w-full py-12 md:py-16 -mb-16 md:-mb-20 z-10">
      {/* Glow effect - extends below to overlay footer */}
      <div className="absolute inset-0 -bottom-8 bg-gradient-to-b from-transparent via-brand-blue/5 to-brand-blue/10 blur-2xl" />
      
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.6 }}
          className="bg-white dark:bg-slate-800/90 border border-slate-200 dark:border-white/10 rounded-2xl md:rounded-3xl p-6 md:p-8 shadow-xl dark:shadow-2xl backdrop-blur-sm relative overflow-hidden"
          style={{
            boxShadow: '0 0 40px rgba(14, 165, 233, 0.15), 0 0 80px rgba(14, 165, 233, 0.08)'
          }}
        >
          {/* Subtle background pattern */}
          <div className="absolute inset-0 opacity-5 dark:opacity-10">
            <div className="absolute inset-0" style={{
              backgroundImage: `radial-gradient(circle at 2px 2px, currentColor 1px, transparent 0)`,
              backgroundSize: '24px 24px'
            }} />
          </div>

          <div className="relative flex flex-col md:flex-row items-center gap-6 md:gap-8">
            {/* Animated Brain Icon */}
            <motion.div
              animate={{
                scale: [1, 1.05, 1],
                rotate: [0, 2, -2, 0],
              }}
              transition={{
                duration: 4,
                repeat: Infinity,
                ease: "easeInOut"
              }}
              className="flex-shrink-0 relative"
            >
              <div className="relative w-20 h-20 md:w-24 md:h-24">
                {/* Brain Container */}
                <div className="mb-6 relative">
              <img 
                src="https://knowbuildwebsiteassets.s3.ap-south-1.amazonaws.com/knowbuild-logo-gif.gif" 
                alt="knowbuild"
                className="w-full h-full object-contain mix-blend-multiply dark:mix-blend-screen"
                style={{
                  filter: 'contrast(1.1) brightness(0.95)',
                }}
              />
            </div>
                
                {/* Glow effect around brain */}
                <motion.div
                  className="absolute inset-0 rounded-full blur-xl"
                  style={{
                    background: 'radial-gradient(circle, rgba(249, 115, 22, 0.3) 0%, rgba(14, 165, 233, 0.3) 50%, transparent 100%)'
                  }}
                  animate={{
                    scale: [1, 1.2, 1],
                    opacity: [0.4, 0.6, 0.4],
                  }}
                  transition={{
                    duration: 3,
                    repeat: Infinity,
                    ease: "easeInOut"
                  }}
                />
              </div>
            </motion.div>

            {/* Text Content */}
            <div className="flex-1 text-center md:text-left">
              <motion.h3
                initial={{ opacity: 0, x: -20 }}
                whileInView={{ opacity: 1, x: 0 }}
                viewport={{ once: true }}
                transition={{ delay: 0.2 }}
                className="text-2xl md:text-3xl font-bold mb-2 leading-tight"
              >
                <span className="text-brand-navy dark:text-white">The Second Brain for</span>{' '}
                <span className="text-brand-teal">Your Business</span>
              </motion.h3>
              <motion.p
                initial={{ opacity: 0, x: -20 }}
                whileInView={{ opacity: 1, x: 0 }}
                viewport={{ once: true }}
                transition={{ delay: 0.3 }}
                className="text-lg md:text-xl font-medium"
              >
                <span className="text-brand-navy dark:text-white">Know your Business.</span>{' '}
                <span className="text-brand-orange">Build it Better</span>
              </motion.p>
            </div>
          </div>
        </motion.div>
      </div>
    </section>
  );
};

