'use client';

import React, { useEffect, useState } from "react";
import { motion } from "framer-motion";

const GradientBackground = () => {
    const [mounted, setMounted] = useState(false);

    useEffect(() => {
        setMounted(true);
    }, []);

    if (!mounted) return null;

    return (
        <div className="relative h-full w-full overflow-hidden bg-slate-50 dark:bg-slate-950 transition-colors duration-700">
            {/* Noise Overlay */}
            <div
                className="absolute inset-0 z-50 opacity-[0.03] pointer-events-none mix-blend-overlay"
                style={{
                    backgroundImage: `url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.65' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)'/%3E%3C/svg%3E")`,
                }}
            />

            {/* Gradient Blobs */}
            <div className="absolute inset-0 blur-[100px] opacity-60 dark:opacity-40">
                {/* Blob 1 - Top Left */}
                <motion.div
                    className="absolute -top-[10%] -left-[10%] w-[50%] h-[50%] rounded-full bg-gradient-to-br from-purple-200 to-blue-200 dark:from-indigo-900 dark:to-blue-900 mix-blend-multiply dark:mix-blend-screen"
                    animate={{
                        x: [0, 100, 0],
                        y: [0, 50, 0],
                        scale: [1, 1.2, 1],
                        rotate: [0, 45, 0],
                    }}
                    transition={{
                        duration: 20,
                        repeat: Infinity,
                        ease: "easeInOut",
                    }}
                />

                {/* Blob 2 - Top Right */}
                <motion.div
                    className="absolute top-[10%] -right-[10%] w-[40%] h-[40%] rounded-full bg-gradient-to-br from-pink-200 to-rose-200 dark:from-purple-900 dark:to-fuchsia-900 mix-blend-multiply dark:mix-blend-screen"
                    animate={{
                        x: [0, -50, 0],
                        y: [0, 100, 0],
                        scale: [1, 1.1, 1],
                        rotate: [0, -30, 0],
                    }}
                    transition={{
                        duration: 25,
                        repeat: Infinity,
                        ease: "easeInOut",
                        delay: 2,
                    }}
                />

                {/* Blob 3 - Bottom Left */}
                <motion.div
                    className="absolute -bottom-[20%] -left-[10%] w-[60%] h-[60%] rounded-full bg-gradient-to-br from-blue-200 to-cyan-200 dark:from-blue-900 dark:to-cyan-900 mix-blend-multiply dark:mix-blend-screen"
                    animate={{
                        x: [0, 50, 0],
                        y: [0, -50, 0],
                        scale: [1, 1.3, 1],
                        rotate: [0, 20, 0],
                    }}
                    transition={{
                        duration: 30,
                        repeat: Infinity,
                        ease: "easeInOut",
                        delay: 4,
                    }}
                />

                {/* Blob 4 - Bottom Right */}
                <motion.div
                    className="absolute -bottom-[10%] -right-[20%] w-[50%] h-[50%] rounded-full bg-gradient-to-br from-amber-100 to-orange-100 dark:from-violet-900 dark:to-purple-900 mix-blend-multiply dark:mix-blend-screen"
                    animate={{
                        x: [0, -100, 0],
                        y: [0, -50, 0],
                        scale: [1, 1.2, 1],
                        rotate: [0, -45, 0],
                    }}
                    transition={{
                        duration: 22,
                        repeat: Infinity,
                        ease: "easeInOut",
                        delay: 6,
                    }}
                />
                {/* Blob 5 - Center */}
                <motion.div
                    className="absolute top-[30%] left-[30%] w-[40%] h-[40%] rounded-full bg-gradient-to-br from-green-100 to-emerald-100 dark:from-slate-800 dark:to-slate-900 mix-blend-multiply dark:mix-blend-screen opacity-50"
                    animate={{
                        x: [0, 30, -30, 0],
                        y: [0, -30, 30, 0],
                        scale: [1, 1.5, 1],
                    }}
                    transition={{
                        duration: 28,
                        repeat: Infinity,
                        ease: "easeInOut",
                        delay: 1,
                    }}
                />
            </div>
        </div>
    );
};

export default GradientBackground;
