'use client';

import React, { ReactNode } from 'react';
import { useZoomLevel } from '../../hooks/useZoomLevel';

interface ZoomAwareContainerProps {
  children: ReactNode;
  className?: string;
  /**
   * Apply zoom-aware responsive classes
   * When true, uses container queries and fluid utilities
   */
  enableZoomAware?: boolean;
}

/**
 * Container component that adapts to browser zoom levels
 * Automatically applies appropriate classes based on detected zoom
 */
export const ZoomAwareContainer: React.FC<ZoomAwareContainerProps> = ({
  children,
  className = '',
  enableZoomAware = true,
}) => {
  const zoomLevel = useZoomLevel();
  
  // Apply zoom-aware classes when zoom is detected
  const zoomAwareClasses = enableZoomAware && zoomLevel > 1.25
    ? 'container-responsive'
    : '';

  return (
    <div 
      className={`${zoomAwareClasses} ${className}`}
      style={{
        // Set CSS variable for zoom level
        '--zoom-factor': zoomLevel.toString(),
      } as React.CSSProperties}
    >
      {children}
    </div>
  );
};

