import { useEffect, useRef } from 'react';
import { useInView } from 'framer-motion';
import { useBackground } from '../context/BackgroundContext';
import { ThemeId } from '../types/theme';

export const useSectionTheme = (theme?: ThemeId) => {
    const ref = useRef<HTMLElement | null>(null);
    // Trigger when the element is in the middle of the viewport
    const isInView = useInView(ref, { margin: "-50% 0px -50% 0px" }); 
    const { setTheme } = useBackground();

    useEffect(() => {
        if (isInView && theme) {
            setTheme(theme);
        }
    }, [isInView, theme, setTheme]);

    return ref;
};
