// SEO configuration for all pages
export const seoConfig = {
    home: {
        url: '/',
        title: 'KnowBuild: Q-ERP + CRM Business Operating System for SMEs',
        description: 'KnowBuild\'s Q-ERP.CRM - an integrated CRM and ERP business operating system built for growing SMEs. Automate sales, finance, inventory, and much more.',
        h1: 'QERP.CRM The Operating System For Growing SMEs',
    },
    solutions: {
        url: '/solutions',
        title: 'India\'s #1 CRM & ERP Solutions for Business Growth | KnowBuild',
        description: 'KnowBuild\'s business automation solutions - CRM, inventory, dispatch, finance & procurement modules. Explore our ERP.CRM systems for B2B SMEs & SaaS companies.',
        h1: 'Business Operating Systems for the Next Generation',
    },
    solutionsOverview: {
        url: '/solutions/b2b-qerp-crm',
        title: 'QERP + CRM for B2B SMEs | KnowBuild',
        description: 'Automate sales, dispatch, procurement & finance with KnowBuild\'s unified business operating system.',
        h1: 'The Business Operating System for Growing SMEs',
    },
    modules: {
        procurement: {
            url: '/solutions/b2b-qerp-crm/procurement',
            title: 'Procurement Module',
            description: 'Streamline purchase orders, approvals, and vendor communication in one system.',
            h1: 'Smarter Procurement Starts Here',
        },
        dispatch: {
            url: '/solutions/b2b-qerp-crm/dispatch',
            title: 'Dispatch Module',
            description: 'Ensure accurate, timely deliveries with UPC-based dispatch automation.',
            h1: 'Deliver with Accuracy & Speed',
        },
        inboundSales: {
            url: '/solutions/b2b-qerp-crm/inbound-sales',
            title: 'Inbound Sales Module',
            description: 'Capture, assign, and track inquiries automatically with KnowBuild\'s inbound sales engine.',
            h1: 'Automate Inquiry Management',
        },
        sales: {
            url: '/solutions/b2b-qerp-crm/sales',
            title: 'Sales Module - Lead & Offer Automation',
            description: 'Auto-assign leads, track offers, and manage follow-ups across your sales funnel.',
            h1: 'Systemize Sales Operations',
        },
        warehousing: {
            url: '/solutions/b2b-qerp-crm/warehousing',
            title: 'Warehousing Module',
            description: 'Monitor stock levels and automate transfers across locations in real time.',
            h1: 'Simplify Warehousing Operations',
        },
        finance: {
            url: '/solutions/b2b-qerp-crm/finance',
            title: 'Finance Module',
            description: 'Manage billing, invoicing, and approvals with real-time credit control visibility.',
            h1: 'Finance in Sync with Operations',
        },
        tendering: {
            url: '/solutions/b2b-qerp-crm/tendering',
            title: 'Tendering Module',
            description: 'Track tenders, bids, and deadlines in one integrated ERP.CRM platform.',
            h1: 'Manage Tenders with Confidence',
        },
        serviceSupport: {
            url: '/solutions/b2b-qerp-crm/service-support',
            title: 'Service Support Module',
            description: 'Track and close service requests efficiently to build customer trust.',
            h1: 'Resolve Faster, Retain Better',
        },
        analytics: {
            url: '/solutions/b2b-qerp-crm/analytics',
            title: 'Analytics & Reporting',
            description: 'View performance analytics across all functions for data-driven decisions.',
            h1: 'Insights That Drive Growth',
        },
        administration: {
            url: '/solutions/b2b-qerp-crm/administration',
            title: 'Administration',
            description: 'Manage access, roles, and settings across teams with clarity.',
            h1: 'Central Control, Simplified',
        },
    },
    mindset: {
        url: '/mindset-grow-your-sme',
        title: 'The KnowBuild Mindset',
        description: 'Reflections from the Architect of KnowBuild on scaling with clarity.',
        h1: 'The Architecture of Growth',
    },
    questions: {
        url: '/forum-erp-crm',
        title: 'ERP.CRM forum, SME Tools Q&A, CRM User Community | KnowBuild',
        description: 'Ask questions and find answers on ERP, CRM, sales, operations, and business systems for B2B SMEs - from real use cases and experts.',
        h1: 'ERP & CRM Questions for B2B SMEs | KnowBuild Forum',
    },
    contact: {
        url: '/contact',
        title: 'Get in Touch with KnowBuild',
        description: 'Connect with the KnowBuild team for demos, onboarding, or partnership inquiries.',
        h1: 'Talk to Us',
    },
    bookDemo: {
        url: '/book-demo',
        title: 'KnowBuild Module Demos',
        description: 'Watch short demo videos showing how KnowBuild automates business operations.',
        h1: 'See KnowBuild in Action',
    },
    pricing: {
        url: '/pricing/b2b-qerp-crm',
        title: 'KnowBuild B2B QERP.CRM Pricing | CRM + ERP for SMEs',
        description: 'Explore KnowBuild B2B QERP.CRM pricing. A CRM + ERP system built for B2B SMEs to manage sales, operations, and execution with clarity.',
        h1: 'KnowBuild B2B QERP.CRM Pricing | CRM + ERP for SMEs',
    },
    privacyPolicy: {
        url: '/privacy-policy',
        title: 'KnowBuild Privacy Policy',
        description: 'Read KnowBuild\'s privacy policy, how we protect your data, information use practices, and users\' rights under our SaaS platform.',
        h1: 'Privacy Policy',
    },
    termsOfService: {
        url: '/terms-of-service',
        title: 'KnowBuild Terms of Service',
        description: 'KnowBuild\'s terms of service describe user obligations, software usage policies, and legal information for our CRM & ERP platform.',
        h1: 'Terms of Service',
    },
};

// Helper to get cross-linking suggestions
export const getCrossLinks = (currentPage: string) => {
    const links: { [key: string]: string[] } = {
        procurement: ['warehousing', 'finance', 'sales'],
        dispatch: ['warehousing', 'sales', 'finance'],
        inboundSales: ['sales', 'analytics'],
        sales: ['inboundSales', 'finance', 'dispatch'],
        warehousing: ['procurement', 'dispatch'],
        finance: ['sales', 'dispatch'],
        tendering: ['sales', 'procurement'],
        serviceSupport: ['sales', 'dispatch'],
        analytics: ['sales', 'finance'],
        administration: ['analytics'],
    };

    return links[currentPage] || [];
};
