import { Filters, StrapiQuery } from "./types";
declare class StrapiQueryBuilder<T> {
    resourceName: string;
    private query;
    constructor(resourceName: string);
    private mergeFilter;
    private op;
    private setPagination;
    filter(incomingFilter: Record<string, any>): this;
    where(field: string, value: any): this;
    sort(field: string, direction?: "asc" | "desc"): this;
    and(...incomingFilter: Filters[]): this;
    or(...incomingFilter: Filters[]): this;
    not(...incomingFilter: Filters[]): this;
    page(page: number): this;
    pageSize(pageSize: number): this;
    withCount(withCount?: boolean): this;
    start(start: number): this;
    limit(limit: number): this;
    status(status: "draft" | "published"): this;
    drafts(): this;
    published(): this;
    locale(locale: string): this;
    fields(...fields: string[]): this;
    select(...fieldArgs: string[]): this;
    populate(...relations: string[]): this;
    populateRelation(relation: string, query: StrapiQuery): this;
    populateQuery<PT>(otherBuilder: StrapiQueryBuilder<PT>): this;
    qs(): string;
    full(): string;
    json(): string;
    get(): StrapiQuery;
}
export declare const query: (resourceName: string) => StrapiQueryBuilder<unknown>;
export {};
