"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.query = void 0;
const qs_1 = require("qs");
const lodash_1 = require("lodash");
class StrapiQueryBuilder {
    constructor(resourceName) {
        this.resourceName = resourceName;
        this.query = {};
    }
    mergeFilter(addition) {
        var _a;
        this.query.filters = (_a = this.query.filters) !== null && _a !== void 0 ? _a : {};
        this.query.filters = Object.assign(Object.assign({}, this.query.filters), addition);
    }
    op(op, ...incomingFilter) {
        var _a, _b;
        this.query.filters = (_a = this.query.filters) !== null && _a !== void 0 ? _a : {};
        this.query.filters[op] = (_b = this.query.filters[op]) !== null && _b !== void 0 ? _b : [];
        const existing = this.query.filters[op];
        this.query.filters[op] = [...existing, ...incomingFilter];
        return this;
    }
    setPagination(key, val) {
        var _a;
        this.query.pagination = (_a = this.query.pagination) !== null && _a !== void 0 ? _a : {};
        this.query.pagination[key] = val;
        return this;
    }
    filter(incomingFilter) {
        this.mergeFilter(incomingFilter);
        return this;
    }
    where(field, value) {
        var _a;
        this.query.filters = (_a = this.query.filters) !== null && _a !== void 0 ? _a : {};
        (0, lodash_1.set)(this.query.filters, field, value);
        return this;
    }
    sort(field, direction = "asc") {
        var _a;
        this.query.sort = (_a = this.query.sort) !== null && _a !== void 0 ? _a : [];
        this.query.sort.push(`${field}:${direction}`);
        return this;
    }
    and(...incomingFilter) {
        return this.op("$and", ...incomingFilter);
    }
    or(...incomingFilter) {
        return this.op("$or", ...incomingFilter);
    }
    not(...incomingFilter) {
        return this.op("$not", ...incomingFilter);
    }
    page(page) {
        return this.setPagination("page", page);
    }
    pageSize(pageSize) {
        return this.setPagination("pageSize", pageSize);
    }
    withCount(withCount = true) {
        return this.setPagination("withCount", withCount);
    }
    start(start) {
        return this.setPagination("start", start);
    }
    limit(limit) {
        return this.setPagination("limit", limit);
    }
    status(status) {
        this.query.status = status;
        return this;
    }
    drafts() {
        return this.status("draft");
    }
    published() {
        return this.status("published");
    }
    locale(locale) {
        this.query.locale = locale;
        return this;
    }
    fields(...fields) {
        this.query.fields = fields;
        return this;
    }
    select(...fieldArgs) {
        return this.fields(...fieldArgs);
    }
    populate(...relations) {
        this.query.populate = relations;
        return this;
    }
    populateRelation(relation, query) {
        var _a;
        this.query.populate = (_a = this.query.populate) !== null && _a !== void 0 ? _a : {};
        this.query.populate[relation] = query;
        return this;
    }
    populateQuery(otherBuilder) {
        var _a;
        this.query.populate = (_a = this.query.populate) !== null && _a !== void 0 ? _a : {};
        this.query.populate[otherBuilder.resourceName] = otherBuilder.get();
        return this;
    }
    qs() {
        return (0, qs_1.stringify)(this.query, { encodeValuesOnly: true });
    }
    full() {
        return `${this.resourceName}?${this.qs()}`;
    }
    json() {
        return JSON.stringify(this.query, null, 2);
    }
    get() {
        return this.query;
    }
}
const query = (resourceName) => new StrapiQueryBuilder(resourceName);
exports.query = query;
//# sourceMappingURL=index.js.map